unit Tools1v1;

interface

// ----------------------------------------------------------------------------
//       integer
function StrToIntPro (WStr : string; var WInt : integer) : boolean;

//       double
function StrToFloatPro (WStr : string; var WDouble : double) : boolean;

// ----------------------------------------------------------------------------
//      
procedure ShowArray(RqArray : array of double);

//     
procedure DWriteToArray(var RqArray : array of double);

implementation
uses SysUtils, AnsiTo866;


//=============================================================================
//           
//=============================================================================

//       integer
function StrToIntPro (WStr : string; var WInt : integer) : boolean;
begin
   Result:=False;      //  
   try
       WInt:= StrToInt(WStr);
       Result:=True;   //       
   except
       WriteLnRus (#09 + '(  integer)/ERROR(Text not integer)');
   end;
end;


// ----------------------------------------------------------------------------
//       double
function StrToFloatPro (WStr : string; var WDouble : double) : boolean;
begin
   Result:=False;     //  
   try
       WDouble:= StrToFloat(WStr);
       Result:=True;  //  
   except
       WriteLnRus (#09 + '(  double)/ERROR(Text not double)');
   end;
end;

//=============================================================================
//         double 
//=============================================================================

//      
procedure ShowArray(RqArray : array of double);
var Ind    : word;    //  
    StrInd : string;  //    
    StrArr : string;  //    
begin
   WriteLn;
   WriteLnRus ('   /SHOW ARRAY'); 
   WriteLnRus ('Index' + #09 + 'Value'); 
   for Ind:=Low(RqArray) to High(RqArray) do
   begin
      StrInd:=IntToStr(Ind);
      StrArr:=FloatToStr(RqArray[Ind]);
      WriteLn(StrInd + #09 + StrArr);
   end;
   WriteLn;
end;

// ----------------------------------------------------------------------------
//       ( )
function StrToIntForArrayIndex (WStr : string; RqArray : array of double) : integer;
var BInt  : integer;
begin
   Result := Low(RqArray) - 1;  //   (index out range)
   if StrToIntPro(WStr, BInt)   //     integer
   then begin
     //      
     if (BInt >= Low(RqArray)) and (BInt <= High(RqArray))
     then begin
        Result := BInt ;      //  
     end
     else begin
       WriteLnRus (#09 + '(  )/ERROR(Index out range)');
     end;
   end;
end;

// ----------------------------------------------------------------------------
//     
procedure DWriteToArray(var RqArray : array of double);
var F1Quit  : boolean;  //      
    F2Quit  : boolean;  //      
    F3Ok    : boolean;  //   
    StrInd  : string;   //    
    StrVal  : string;   //    
    Ind     : integer;  //   
    Val     : double;   //   
begin
    WriteLn;
    WriteLn    ('==========================================');
    WriteLnRus ('  /IMPUT ARRAY ELEMENT.');
    WriteLnRus ('  /Index range ('
               + IntToStr(Low(RqArray))
               + '..'
               + IntToStr(High(RqArray))
               + ')'
               );
    WriteLn   ('------------------------------------------');

    Ind := Low(RqArray)-1;  //   (index out range)
    F1Quit := False;        //    
    repeat
       WriteRus ('   /Imput INDEX : ');
       ReadLn(StrInd);
       if UpCase(StrInd[1]) = 'Q'
       then begin
          //    
          F1Quit:=True;
       end
       else begin
          //        
          Ind := StrToIntForArrayIndex (StrInd, RqArray);
       end;
    until ((Ind >= Low(RqArray)) or F1Quit);

    F2Quit := False;  //    
    F3Ok   := False;  //    
    if (not F1Quit)
    then begin
       repeat
          WriteRus (' /Imput VALUE : ');
          ReadLn(StrVal);
          if UpCase(StrVal[1]) = 'Q'
          then F2Quit := True
          else F3Ok   := StrToFloatPro (StrVal, Val);
       until (F3Ok or F2Quit);
    end;
    //         ,
    //    
    if (not F1Quit) and (not F2Quit) and F3Ok
    then begin
       RqArray[Ind]:=Val;
       WriteLnRus ('   /SUCCESS');
    end
    else begin
       WriteLnRus (' /Operation CANCELED');
    end;
    WriteLn  ('==========================================');
    WriteLn;
end;

// ----------------------------------------------------------------------------



// ----------------------------------------------------------------------------
end.